<?php
/*--------------------------------------------------------------
   Options.php 2021-05-31
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections;

use ArrayIterator;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option;
use InvalidArgumentException;
use IteratorAggregate;
use Webmozart\Assert\Assert;

class Options implements IteratorAggregate
{
    /**
     * @var Option[]
     */
    private $values;
    
    
    /**
     * Constructor.
     */
    private function __construct(array $values)
    {
        $this->values = $values;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Option ...$options): self
    {
        return new self($options);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): ArrayIterator
    {
        return new ArrayIterator($this->values);
    }
    
    
    /**
     * Return option by ID.
     */
    public function getById(string $id): Option
    {
        Assert::stringNotEmpty($id);
        
        /**
         * @var Option $option
         */
        foreach ($this->values as $option) {
            if ($id === $option->id()->value()) {
                return $option;
            }
        }
        
        throw new InvalidArgumentException("Option not found");
    }
    
    
    /**
     * Validate option update set.
     */
    public function validateUpdateSet(array $updateSet): void
    {
        $ids = array_map(function (Option $option) {
            return $option->id()->value();
        },
            $this->values);
        
        foreach (array_keys($updateSet) as $id) {
            Assert::inArray($id, $ids);
        }
    }
}